### Nginx 配置
```nginx
location / {
    
    # 检查 Content-Type 是否为 application/grpc
    if ($content_type = "application/grpc") {
      grpc_pass grpc://127.0.0.1:2000;
      break;
    }
    
    # 非 gRPC 请求走普通 HTTP 代理
    proxy_pass http://127.0.0.1:2000;
    proxy_set_header Host $host;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header REMOTE-HOST $remote_addr;
    proxy_set_header X-Host $host:$server_port;
    proxy_set_header X-Scheme $scheme;
    proxy_connect_timeout 30s;
    proxy_read_timeout 86400s;
    proxy_send_timeout 30s;
    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection "upgrade";
    
    # 特别针对SSE的优化
    # proxy_buffering off;
    # proxy_cache off;
}
```

### 抽卡设计
1、稀有度等级：白、绿、蓝、紫、金、红（白色等级最低，红色等级最高）
2、单抽和10连抽，每十连至少出现一个紫色，最多出现3个紫色
3、金色保底90抽，红色保底300抽，有万分之一的概率在90抽之前出现金色
4、如果在90抽内没有出现金色，则第90抽必定为金色，如果在300抽内没有出现红色，则第300抽必定为红色
5、出现金色后，重置金色保底计数器，出现红色后，重置红色保底计数器
6、白色爆率为70%，绿色爆率为20%，蓝色爆率为8%，紫色爆率为1.5%，金色爆率为0.4%，红色爆率为0.1%


抽卡系统技术设计方案 V2.1
1. 概述
   本文档描述了游戏中抽卡系统的详细设计，包含稀有度分级、概率设定、保底机制及十连抽特殊规则。核心特点是单次抽卡可获多个道具，且保底机制与十连保底机制通过优先级和补偿逻辑协同工作，确保规则无冲突。

2. 基础规则
   2.1 稀有度与概率
   每次抽卡获得的每个道具，其稀有度独立按以下概率分布：

稀有度	颜色	概率（单道具）
普通	白色	70%
优良	绿色	20%
精良	蓝色	8%
史诗	紫色	1.5%
传说	金色	0.4%
神话	红色	0.1%
2.2 单次抽卡结果
单次抽卡（1抽）的结果是一个道具列表（Item List），包含至少1个、至多N个道具。

列表中每个道具的稀有度都独立根据上述概率随机生成。

2.3 保底机制
系统为每个玩家维护两个独立的保底计数器：

pity_counter_gold (初始为0)

pity_counter_red (初始为0)

金色保底：当 pity_counter_gold 达到 89 (即第90抽)时，下一次单次抽卡的结果列表中将必定包含至少一个金色（或红色）道具。

红色保底：当 pity_counter_red 达到 299 (即第300抽)时，下一次单次抽卡的结果列表中将必定包含至少一个红色道具。

计数器重置：

当一次抽卡的结果列表中包含了金色或红色道具，则重置 pity_counter_gold = 0。

当一次抽卡的结果列表中包含了红色道具，则重置 pity_counter_red = 0。

计数器递增：每次进行一次抽卡（无论单抽还是十连中的一次），两个计数器都+1。未触发保底且未抽中金色/红色时，计数器持续累加。

3. 十连抽规则
   十连抽视为进行10次独立的单次抽卡。

3.1 紫卡数量调控规则
十连抽的最终结果必须满足：10次抽卡的结果合并后，其道具总列表中必须包含至少1个紫色或更高稀有度的道具。

为保证资源投放稳定且富有惊喜，对紫色道具数量进行如下调控：

系统模拟完10次抽卡后，统计合并结果中紫色道具的总数量（记为 purple_count），金色和红色道具不参与此数量调控。

如果 purple_count == 0：

系统会强制将10次结果中的一个蓝色道具升级为一个紫色道具。此时最终 purple_count = 1。

如果 purple_count >= 1：

系统有 90% 的概率，将 purple_count 强制设置为 1。

实现方式：随机保留一个原生的紫色（或更高）道具，将其他紫色道具降级为蓝色道具。

系统有 10% 的概率，保留 purple_count 的原始数量（即允许出现2个或3个甚至更多紫色道具）。

特别注意：以上数量调控仅针对紫色道具，任何情况下都不应对金色或红色道具进行降级或替换。

3.2 十连与保底的优先级处理
规则：高稀有度保底优先于十连紫卡数量调控。

当十连中的某一次抽卡（例如第90抽）触发金色或红色保底时：

首先，保证该次抽卡的结果中包含保底应得的金色/红色道具。

然后，执行上述 3.1 的十连紫卡数量调控规则。

这意味着，一次触发保底的抽卡，其结果可能是【1金 + 1紫】或【1红 + 1紫】。